% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dy_d_wrt.R
\name{dy.d_}
\alias{dy.d_}
\title{Partial Derivative dy/d_[wrt]}
\usage{
dy.d_(x, y, wrt, eval.points = "obs", mixed = FALSE, messages = TRUE)
}
\arguments{
\item{x}{a numeric matrix or data frame.}

\item{y}{a numeric vector with compatible dimensions to \code{x}.}

\item{wrt}{integer; Selects the regressor to differentiate with respect to (vectorized).}

\item{eval.points}{numeric or options: ("obs", "apd", "mean", "median", "last"); Regressor points to be evaluated.
\itemize{
\item Numeric values must be in matrix or data.frame form to be evaluated for each regressor, otherwise, a vector of points will evaluate only at the \code{wrt} regressor.  See examples for use cases.
\item Set to \code{(eval.points = "obs")} (default) to find the average partial derivative at every observation of the variable with respect to \emph{for specific tuples of given observations.}
\item Set to \code{(eval.points = "apd")} to find the average partial derivative at every observation of the variable with respect to \emph{over the entire distribution of other regressors.}
\item Set to \code{(eval.points = "mean")} to find the partial derivative at the mean of value of every variable.
\item Set to \code{(eval.points = "median")} to find the partial derivative at the median value of every variable.
\item Set to \code{(eval.points = "last")} to find the partial derivative at the last observation of every value (relevant for time-series data).
}}

\item{mixed}{logical; \code{FALSE} (default) If mixed derivative is to be evaluated, set \code{(mixed = TRUE)}.}

\item{messages}{logical; \code{TRUE} (default) Prints status messages.}
}
\value{
Returns column-wise matrix of wrt regressors:
\itemize{
\item{\code{dy.d_(...)[, wrt]$First}} the 1st derivative
\item{\code{dy.d_(...)[, wrt]$Second}} the 2nd derivative
\item{\code{dy.d_(...)[, wrt]$Mixed}} the mixed derivative (for two independent variables only).
}
}
\description{
Returns the numerical partial derivative of \code{y} with respect to [wrt] any regressor for a point of interest.  Finite difference method is used with \link{NNS.reg} estimates as \code{f(x + h)} and \code{f(x - h)} values.
}
\note{
For binary regressors, it is suggested to use \code{eval.points = seq(0, 1, .05)} for a better resolution around the midpoint.
}
\examples{
\dontrun{
set.seed(123) ; x_1 <- runif(1000) ; x_2 <- runif(1000) ; y <- x_1 ^ 2 * x_2 ^ 2
B <- cbind(x_1, x_2)

## To find derivatives of y wrt 1st regressor for specific points of both regressors
dy.d_(B, y, wrt = c(1, 2), eval.points = t(c(.5, .5)))

## To find average partial derivative of y wrt 1st regressor,
only supply 1 value in [eval.points], or a vector of [eval.points]:
dy.d_(B, y, wrt = 1, eval.points = .5)

dy.d_(B, y, wrt = 1, eval.points = fivenum(B[,1]))


## To find average partial derivative of y wrt 1st regressor,
for every observation of 1st regressor:
apd <- dy.d_(B, y, wrt = 1, eval.points = "apd")
plot(B[,1], apd[,1]$First)

## 95\% Confidence Interval to test if 0 is within
### Lower CI
LPM.VaR(.025, 0, apd[,1]$First)

### Upper CI
UPM.VaR(.025, 0, apd[,1]$First)
}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995/ref=cm_sw_su_dp}

Vinod, H. and Viole, F. (2020) "Comparing Old and New Partial Derivative Estimates from Nonlinear Nonparametric Regressions"
\url{https://www.ssrn.com/abstract=3681104}
}
\author{
Fred Viole, OVVO Financial Systems
}
