% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NORMA.R
\name{f}
\alias{f}
\title{Predictor Function}
\usage{
f(point, t, x, alpha, beta, f_0, kernel = function(x, y, gamma) {    
  exp(-gamma * (norm(x - y, type = "2")^2)) }, gamma, no_beta)
}
\arguments{
\item{point}{\code{numeric} with the value of the point where we want to evaluate the predictor function.}

\item{t}{time parameter value indicating the iteration we want to consider.}

\item{x}{\code{matrix} containing training points. Each row must be
a point.}

\item{alpha}{\code{matrix} representing \eqn{\alpha} parameters of NORMA optimization in each iteration, one per row.}

\item{beta}{\code{numeric} representing \eqn{\beta} parameter of NORMA optimization in each iteration.}

\item{f_0}{initial hypothesis.}

\item{kernel}{kernel function to use.}

\item{gamma}{gaussian kernel parameter \eqn{\gamma}.}

\item{no_beta}{\code{boolean} indicating if an offset \eqn{b} is used (FALSE) or not (TRUE).}
}
\value{
Returns a \code{numeric} representing the prediction value.
}
\description{
Computes the predictor function of a general noise SVR based on NORMA optimization.
}
\examples{
f(c(1,2,3),2,matrix(c(1,2,3,4,5,6),nrow=2,ncol=3,byrow=TRUE),
matrix(c(1,2,3,4,5,6),nrow=2,ncol=3,byrow=TRUE),
c(1,2),0,function(x,y,gamma=0){x\%*\%y},0.1,FALSE)
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}
\references{
Link to the scientific paper

Kivinen J., Smola A. J., Williamson R.C.: Online learning with kernels. In: IEEE
transactions on signal processing, vol. 52, pp. 2165-2176, IEEE (2004).

with theoretical background for NORMA optimization is provided below.

\url{http://realm.sics.se/papers/KivSmoWil04(1).pdf}
}

