% Generated by roxygen2 (4.0.2): do not edit by hand
\name{nortaRA-package}
\alias{nortaRA}
\alias{nortaRA-package}
\title{Simultaneous generation of multivariate data with arbitrary marginals}
\description{
This package implements a specific method for generating n-dimensional random
vectors with given marginal distributions and correlation matrix. The method
uses the NORTA(NORmal To Anything) approach which generates a standard normal
random vector and then transforms it into a random vector with specified
marginal distributions and the RA(Retrospective Approximation) algorithm which
is a generic stochastic root-finding algorithm. Data generation is
accomplished by first using \code{\link{BoundingRA}} to calculate an
intermediate multivariate normal correlation matrix, then the matrix is used
to generate samples from multivariate normal distribution. The engine function
\code{\link{genNORTARA}} will transforms the normal samples to the wanted data
set with specified inputmarginals from users. The function
\code{\link{valid_input_cormat}} returns the lower and upper bounds of the
mixture pre-specified marginal distributions. The function
\code{\link{check_input_cormat}} checks the input target correlation matrix
whether it is in the lower and upper bounds, if in the bounds, then the
function will return \code{TRUE} it means the input target correaltion matrix
is feasible, otherwise, it will print the  elements' positions which are out
of bounds and give an error message.
}
\details{
\tabular{ll}{ Package: \tab nortaRA\cr Type: \tab Package\cr Version:
 \tab 1.0.0\cr Date: \tab 2014-12-06\cr License: \tab MIT + file LICENSE }
}
\author{
Po Su \cr Maintainer: Po Su \email{desolator@sjtu.edu.cn}
}

