% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{uTAR}
\alias{uTAR}
\title{Estimation of a Univariate Two-Regime SETAR Model}
\usage{
uTAR(y, p1, p2, d = 1, thrV = NULL, Trim = c(0.15, 0.85), k0 = 300,
  include.mean = T, thrQ = c(0, 1))
}
\arguments{
\item{y}{a vector of time series.}

\item{p1, p2}{AR-orders of regime 1 and regime 2.}

\item{d}{delay for threshold variable, default is 1.}

\item{thrV}{threshold variable. If thrV is not null, it must have the same length as that of y.}

\item{Trim}{lower and upper quantiles for possible threshold values.}

\item{k0}{the maximum number of threshold values to be evaluated. If the sample size is large (> 3000), then k0 = floor(nT*0.5).The default is k0=300. But k0 = floor(nT*0.8) if nT < 300.}

\item{include.mean}{a logical value indicating whether constant terms are included.}

\item{thrQ}{lower and upper quantiles to search for threshold value.}
}
\value{
uTAR returns a list with components:
\item{data}{the data matrix, y.}
\item{arorder}{AR orders of regimes 1 and 2.}
\item{delay}{the delay for threshold variable.}
\item{residuals}{estimated innovations.}
\item{coef}{a 2-by-(p+1) matrices. The first row show the estimation results in regime 1, and the second row shows these in regime 2.}
\item{sigma}{estimated innovational covariance matrices of regimes 1 and 2.}
\item{nobs}{numbers of observations in regimes 1 and 2.}
\item{model1,model2}{estimated models of regimes 1 and 2.}
\item{thr}{threshold value.}
\item{D}{a set of threshold values.}
\item{RSS}{RSS}
\item{AIC}{AIC value}
\item{cnst}{logical values indicating whether the constant terms are included in regimes 1 and 2.}
\item{sresi}{standardized residuals.}
}
\description{
Estimation of a univariate two-regime SETAR model, including threshold value.
The procedure of Li and Tong (2016) is used to search for the threshold.
}
\examples{
arorder=rep(1,2)
ar.coef=matrix(c(0.7,-0.8),2,1)
y=uTAR.sim(100,arorder,ar.coef,1,0)
est=uTAR(y$series,1,1,1,y$series,c(0.2,0.8),100,TRUE,c(0.2,0.8))
}
\references{
Li, D., and Tong. H. (2016) Nested sub-sample search algorithm for estimation of threshold models. \emph{Statisitca Sinica}, 1543-1554.
}
