% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netfacs_network.R
\name{netfacs_network}
\alias{netfacs_network}
\alias{netfacs.network}
\title{Creates a network object out of the netfacs data}
\usage{
netfacs_network(
  netfacs.data,
  link = "unweighted",
  significance = 0.01,
  min.count = 1,
  min.prob = 0,
  ignore.element = NULL
)

netfacs.network(
  netfacs.data,
  link = "unweighted",
  significance = 0.01,
  min.count = 1,
  min.prob = 0,
  ignore.element = NULL
)
}
\arguments{
\item{netfacs.data}{object resulting from \code{\link{netfacs}} function}

\item{link}{determines how nodes/elements are connected. 'unweighted' gives a
1 to significant connections and 0 to all others; 'weighted' gives the
difference between observed and expected probability of co-occurrence;
'raw' just uses the observed probability of co-occurrence}

\item{significance}{numeric value, determining the p-value below which
combinations are considered to be dissimilar enough from the null
distribution}

\item{min.count}{numeric value, suggesting how many times a combination
should at least occur to be displayed}

\item{min.prob}{numeric value, suggesting the probability at which a
combination should at least occur to be displayed}

\item{ignore.element}{vector of elements that will not be considered for the
network, e.g. because they are too common or too rare or their
interpretation is not relevant here}
}
\value{
Function returns a network object where the nodes are the elements,
  edges represent their co-occurrence, and the vertex and edge attributes
  contain all additional information from the netfacs object
}
\description{
Takes the results of the nefacs object for combinations of 2 elements and
turns them into a network object (igraph) that can be used for
further plotting and analyses
}
\examples{
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 100,
  combination.size = 2
)

anger.net <- netfacs_network(
  netfacs.data = angry.face,
  link = "unweighted",
  significance = 0.01,
  min.count = 1
)
}
