% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patch-functions.R
\name{patchAt}
\alias{patchAt}
\alias{patchAt,worldNLR,matrix,numeric,numeric-method}
\title{\code{Patches} at}
\usage{
patchAt(world, agents, dx, dy, torus = FALSE)

\S4method{patchAt}{worldNLR,matrix,numeric,numeric}(world, agents, dx, dy, torus = FALSE)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}

\item{agents}{Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second
column \code{pycor} representing the \code{patches} coordinates, or

\if{html}{\out{<div class="sourceCode">}}\preformatted{          `AgentMatrix` object representing the moving `agents`.
}\if{html}{\out{</div>}}}

\item{dx}{Numeric. Vector of distances to the east (right) from the \code{agents}.
If \code{dx} is negative, the distance to the west (left) is computed.
\code{dx} must be of length 1 or of the same length as number of \code{patches}
or \code{turtles} in \code{agents}.}

\item{dy}{Numeric. Vector of distances to the north (up) from the \code{agents}.
If \code{dy} is negative, the distance to the south is computed (down).
\code{dy} must be of length 1 or of the same length as number of \code{patches}
or \code{turtles} in \code{agents}.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
Matrix (\code{ncol} = 2) with the first column \code{pxcor} and the second column
\code{pycor} representing the coordinates of the \code{patches} at \verb{(dx, dy)}
distances of the \code{agents}. The order of the \code{patches} follows the order
of the \code{agents}.
}
\description{
Report the coordinates of the \code{patches} at \verb{(dx, dy)} distances of the \code{agents}.
}
\details{
If the \code{patch} at distance \verb{(dx, dy)}
of an \code{agent} is outside of the \code{world}'s extent and \code{torus = FALSE},
\code{NA} are returned
for the \code{patch} coordinates;
if \code{torus = TRUE}, the \code{patch} coordinates from a wrapped \code{world} are
returned.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
patchCorner <- patchAt(world = w1, agents = patch(w1, 0, 0), dx = 1, dy = 1)
t1 <- createTurtles(n = 1, coords = cbind(xcor = 0, ycor = 0))
patchCorner <- patchAt(world = w1, agents = t1, dx = 1, dy = 1)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
Center for Connected Learning and Computer-Based Modeling,
Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#patch-at}

\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#at-points}
}
\author{
Sarah Bauduin
}
