% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/world-functions.R
\name{world2spatRast}
\alias{world2spatRast}
\alias{world2spatRast,worldMatrix-method}
\alias{world2spatRast,worldArray-method}
\title{Convert a \code{worldMatrix} or \code{worldArray} object into a \code{SpatRaster} object}
\usage{
world2spatRast(world)

\S4method{world2spatRast}{worldMatrix}(world)

\S4method{world2spatRast}{worldArray}(world)
}
\arguments{
\item{world}{\code{WorldMatrix} or \code{worldArray} object.}
}
\value{
\code{SpatRaster} object.
\code{Patches} value are retained from the \code{world}.
}
\description{
Convert a \code{worldMatrix} object or a
\code{worldArray} object into a \code{SpatRaster} object
}
\details{
The \code{SpatRaster} returned has the same extent and resolution as the \code{world}
with round coordinates at the center of the cells and coordinates \code{x.5}
at the edges of the cells.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9, data = runif(100))
r1 <- world2spatRast(w1)
terra::plot(r1)

w2 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9, data = 0)
w3 <- stackWorlds(w1, w2)
r3 <- world2spatRast(w3)
terra::plot(r3)

}
\author{
Sarah Bauduin
}
