% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmsbm.R
\name{mmsbm}
\alias{mmsbm}
\title{Dynamic mixed-membership stochastic blockmodel with covariates}
\usage{
mmsbm(formula.dyad, formula.monad = ~1, senderID, receiverID,
  nodeID = NULL, timeID = NULL, data.dyad, data.monad = NULL,
  n.blocks, n.hmmstates = 1, directed = TRUE,
  missing = "indicator method", mmsbm.control = list())
}
\arguments{
\item{formula.dyad}{A \code{formula} object. The variable in \code{data.dyad} that contains 
binary edges should be used as a LHS, and any dyadic predictors 
can be included on the RHS (when no dyadic covariates are available, use \code{y ~ 1}).
Same syntax as a \code{glm} formula.}

\item{formula.monad}{An optional \code{formula} object. LHS is ignored. RHS contains 
names of nodal atrributes found in \code{data.monad}.}

\item{senderID}{Character string. Quoted name of the variable in \code{data.dyad} identifying 
the sender node. For undirected networks, the variable simply contains name of first node 
in dyad. Cannot contain special charecter "`@`".}

\item{receiverID}{Character string. Quoted name of the variable in \code{data.dyad} identifying 
the receiver node. For undirected networks, the variable simply contains name of second node 
in dyad. Cannot contain special charecter "`@`".}

\item{nodeID}{Character string. Quoted name of the variable in \code{data.monad} identifying 
a node in either \code{data.dyad[,senderID]} or \code{data.dyad[,senderID]}. If not \code{NULL},
every node \code{data.dyad[,senderID]} or \code{data.dyad[,senderID]} must be present in 
\code{data.monad[,nodeID]}. Cannot contain special charecter "`@`".}

\item{timeID}{Character string. Quoted name of the variable in both \code{data.dyad} and
\code{data.monad} indicating the time in which network (and correspding nodal atrributes)
were observed. The variable itself must be composed of integers. Cannot contain special charecter "`@`".}

\item{data.dyad}{Data frame. Sociomatrix in ``long'' (i.e. dyadic) format. Must contain at
least three variables: the sender identifier (or identifier of the first node in an undirected networks dyad),
the receiver identifier (or identifier of the second node in an undirected network dyad), and the value
of the edge between them. Currently, only edges between zero and one (inclusive) are supported.}

\item{data.monad}{Data frame. Nodal atributes. Must contain a node identifier matching the names of nodes
used in the \code{data.dyad} data frame.}

\item{n.blocks}{Integer value. How many latent groups should be used to estimate the model?}

\item{n.hmmstates}{Integer value. How many hidden Markov state should be used in the HMM? Defaults 
to 1 (i.e. no HMM).}

\item{directed}{Boolean. Is the network directed? Defaults to \code{TRUE}.}

\item{missing}{Means of handling missing data. One of "indicator method" (default) or "listwise deletion".}

\item{mmsbm.control}{A named list of optional algorithm control parameters.
\describe{
   \item{spectral}{Boolean. Type of initialization algorithm for mixed-membership vectors in static case. If \code{TRUE} (default),
               use spectral clustering with degree correction; otherwise, use kmeans algorithm.}
   \item{init.dyn.gibbs}{Boolean. Should a collapsed Gibbs sampler of non-regression mmsbm be used to initialize
               each time period when multiple time periods are observed (instead of a spectral or simple kmeans initialization)?
               Setting to \code{TRUE} will be result in faster estimation that is very sensitive to
               choice of alpha (see below)}            
   \item{alpha}{Numeric positive value. Concentration parameter for collapsed Gibbs sampler to find initial
                mixed-membership values in dynamic case when \code{init.dyn.gibbs=TRUE}. Defaults to 0.5}            
   \item{seed}{RNG seed. Defaults to \code{NULL}, which does not seed the RNG}            
   \item{em_iter}{Number of maximum iterations in variational EM. Defaults to 5e3}
   \item{opt_iter}{Number of maximum iterations of BFGS in M-step. Defaults to 10e3}
   \item{mu_b}{Numeric vector with two elements: prior mean of blockmodel's main diagonal elements, and
               and prior mean of blockmodel's offdiagonal elements. Defaults to \code{c(5.0, -5.0)}}
   \item{var_b}{Numeric vector with two positive elements: prior variance of blockmodel's main diagonal elements, and
               and prior variance of blockmodel's offdiagonal elements. Defaults to \code{c(1.0, 1.0)}}
   \item{var_beta}{Numeric positive value. (Gaussian) Prior variance of monadic coefficients. Defaults to 5.0.}
   \item{var_gamma}{Numeric positive value. (Gaussian) Prior variance of dyadic coefficients. Defaults to 5.0.}
   \item{eta}{Numeric positive value. Concentration hyper-parameter for HMM. Defaults to 10.3}
   \item{phi_init_t}{Matrix, \code{n.blocks} by total number of nodes across years. Optional initial values for variational
                  parameters for mixed-membership vectors. Column names must be of the form \code{nodeid\@year}
                  }
   \item{kappa_init_t}{Matrix, \code{n.hmmstates} by number of years. Optional initial values for variational 
                  parameters for state probabilities.}
   \item{b_init_t}{Matrix, \code{n.blocks} by \code{n.blocks}. Optional initial values for blockmodel.}
   \item{beta_init}{Array, predictors by \code{n.blocks} by \code{n.hmmstates}. Optional initial values for monadic coefficients.}
   \item{gamma_init}{Vector. Optional initial values for dyadic coefficients.}
   \item{permute}{Boolean. Should all permutations be tested to realign initial block models in dynamic case? If \code{FALSE}, realignment is 
                 done via faster graph matching algorithm, but may not be exact. Defaults to \code{TRUE}.}
   \item{threads}{Numeric integer. Number of available cores for paralellization. Defaults to 4}
   \item{conv_tol}{Numeric value. Absolute tolerance for VI convergence. Defaults to 1e-4}
   \item{verbose}{Boolean. Should extra information be printed as model iterates? Defaults to FALSE}
   }}
}
\value{
Object of class \code{mmsbm}. List with named components:
    \describe{
      \item{MixedMembership}{Matrix of variational posterior of mean of mixed-membership vectors. \code{nodes} by \
                             \code{n.groups}}
      \item{BlockModel}{\code{n.groups} by \code{n.groups} matrix of estimated tie log-odds between members
                        of corresponding latent groups. The blockmodel.}
      \item{MonadCoef}{Array of estimated coefficient values for monadic covariates. Has \code{n.groups} columns,
                       and \code{n.hmmstates} slices.}
      \item{DyadCoef}{Vector estimated coefficient values for dyadic covariates}
      \item{TransitionKernel}{Matrix of estimated HMM transition probabilities}
      \item{Kappa}{Matrix of marginal probabilities of being in an HMM state at any given point in time. 
                   \code{n.hmmstates} by years (or whatever time interval networks are observed at)}
      \item{LowerBound}{Value of the lower bound at final iteration}
      \item{niter}{Final number of VI iterations}
      \item{converged}{Convergence indicator; zero indicates failure to converge}
      \item{NodeIndex}{Order in which nodes are stored in all return objects}
      \item{monadic.data, dyadic.data, directed}{Original values of parameters used during estimation}
      \item{forms}{Values of formal arguments passed in original function call}
      \item{call}{Original (unevaluated) call}
    }
}
\description{
The function estimates a dynamic mixed-membership stochastic
blockmodel that incorporates covariates.
}
\examples{
library(NetMix)
## Load datasets
data("lazega_dyadic")
data("lazega_monadic")
## Estimate model with 2 groups
set.seed(123)
lazega_mmsbm <- mmsbm(SocializeWith ~ Coworkers,
                      ~  School + Practice + Status,
                      senderID = "Lawyer1",
                      receiverID = "Lawyer2",
                      nodeID = "Lawyer",
                      data.dyad = lazega_dyadic,
                      data.monad = lazega_monadic,
                      n.blocks = 2)

}
\author{
Kosuke Imai (imai@harvard.edu), Tyler Pratt (tyler.pratt@yale.edu), Santiago Olivella (olivella@unc.edu)
}
