% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/auxfuns.R
\name{approxB}
\alias{approxB}
\alias{getZ}
\alias{alphaLB}
\alias{auxfuns}
\alias{.cbind.fill}
\alias{.transf_muvar}
\alias{.bar.legend}
\alias{.mpower}
\alias{.findPerm}
\alias{.transf}
\alias{.pi.hat}
\alias{.e.pi}
\title{Internal functions and generics for \code{mmsbm} package}
\usage{
approxB(y, d_id, pi_mat)

getZ(pi_mat)

alphaLB(par, tot_nodes, c_t, x_t, s_mat, t_id, var_beta, mu_beta)

.cbind.fill(...)

.transf_muvar(
  orig,
  is_var,
  is_array,
  des.mat,
  nblock = NULL,
  nstate = NULL,
  devs = NULL
)

.bar.legend(colPalette, range)

.mpower(mat, p)

.findPerm(block_list, target_mat = NULL, use_perms = TRUE)

.transf(mat)

.pi.hat(X, beta)

.e.pi(pi_l, kappa)
}
\arguments{
\item{y}{Numeric vector; vector of edge values.}

\item{d_id}{Integer matrix; two-column matrix with nr. dyads rows, containing zero-based
sender (first column) and receiver (second column) node id's for each dyad.}

\item{pi_mat}{Numeric matrix; row-stochastic matrix of mixed-memberships.}

\item{par}{Vector of parameter values.}

\item{tot_nodes}{Integer vector; total number of nodes each node interacts with.}

\item{c_t}{Integer matrix; samples from Poisson-Binomial counts of a node instantiating a group.}

\item{x_t}{Numeric matrix; transposed monadic design matrices.}

\item{s_mat}{Integer matrix; Samples of HMM states by time period.}

\item{t_id}{Integer vector; for each node, what time-period is it observed in? zero-indexed.}

\item{mu_beta, var_beta}{Numeric arrays; prior mean and variances of monadic coefficients.}

\item{...}{Numeric vectors; vectors of potentially different length to be cbind-ed.}

\item{orig}{Object to be transformed.}

\item{is_var}{Boolean. Is the object to be transformed a variance term?}

\item{is_array}{Boolean. Is the object to be transformed an array?}

\item{des.mat}{Numeric matrix. Design matrix corresponding to transformed object.}

\item{nblock}{Number of groups in model, defaults to \code{NULL}.}

\item{nstate}{Number of hidden Markov states in model, defaults to \code{NULL}.}

\item{devs}{Vector of standard deviations to use in transformation of variances. Defaults to \code{NULL}.}

\item{colPalette}{A function produced by \code{colorRamp}.}

\item{range}{The range of values to label the legend.}

\item{mat}{Numeric matrix}

\item{p}{Numeric scalar; power to raise matrix to.}

\item{block_list}{List of matrices; each element is a square, numeric matrix 
that defines a blockmodel,}

\item{target_mat}{Numeric matrix; reference blockmodel that those in block_list should 
be aligned to. Optional, defaults to \code{NULL}.}

\item{use_perms}{Boolean; should all row/column permutations be explored when
realigning matrices? defaults to \code{TRUE}.}

\item{X}{Numeric matrix; design matrix of monadic predictors.}

\item{beta}{Numeric array; array of coefficients associated with monadic predictors. 
It of dimensions Nr. Predictors by Nr. of Blocks by Nr. of HMM states.}

\item{pi_l}{List of mixed-membership matrices.}

\item{kappa}{Numeric matrix; matrix of marginal HMM state probabilities.}
}
\value{
See individual return section for each function:
\describe{
      \item{.cbind.fill}{Matrix of \code{cbind}'ed elements in \code{...}, with missing values in each vector filled with \code{NA}.}
      \item{.mpower}{Matrix; the result of raising \code{mat} to the \code{p} power.}
      \item{.findPerm}{List of permuted blockmodel matrices}
      \item{.transf}{Matrix with transformed mixed-membership vectors along its rows, s.t. no element is equal to 0.0 or 1.0.}
      \item{.pi.hat}{List of predicted mixed-membership matrices, one element per HMM state.}
      \item{.e.pi }{Matrix of expected mixed-membership vectors along its rows, with expectation computed over marginal 
                    distribution over HMM states for each time period.}
    }
}
\description{
These are various utilities and generic methods used by 
the main package function.
}
\details{
These functions are meant for internal use only.
}
\author{
Santiago Olivella (olivella@unc.edu), Adeline Lo (aylo@wisc.edu), Tyler Pratt (tyler.pratt@yale.edu), Kosuke Imai (imai@harvard.edu)
}
