% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.diffnet}
\alias{plot.diffnet}
\title{Visualize netinf output}
\usage{
\method{plot}{diffnet}(x, type = "network", ...)
}
\arguments{
\item{x}{object of class diffnet to be plotted.}

\item{type}{character, one of \code{c("network", "improvement")} indicating if 
the inferred diffusion network (\code{"network"}) or the improvement for each
edge should be visualized (\code{"improvement"}).}

\item{...}{additional arguments.}
}
\value{
A ggplot plot object if \code{type = "improvement"} otherwise an 
    igraph plot.
}
\description{
Visualize the inferred diffusion network or the marginal gain in fit obtained
by addition of each edge.
}
\details{
If `type = improvement` a ggplot object is returned. It can be modified like
any other ggplot. See the ggplot documentation and the examples in 
\link{plot.cascade}.
}
\examples{

\dontrun{
 data(cascades)
 res <- netinf(cascades, n_edges = 6, lambda = 1)
 plot(res, type = "network")
 plot(res, type = "improvement")
}

}
