% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{ClustCoeff}
\alias{ClustCoeff}
\title{Clustering Coefficient}
\usage{
ClustCoeff(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted? Defaults to FALSE. Set to TRUE for weighted measures of CC and CCi}
}
\value{
Returns a list of CC and CCi
}
\description{
Computes global clustering coefficient (CC) and local clustering coefficient (CCi)
}
\examples{
unweighted_CC<-ClustCoeff(A)

weighted_CC<-ClustCoeff(A,weighted=TRUE)
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
Neuroimage, 52(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
