% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{nams}
\alias{nams}
\title{Network Adjusted Mean/Sum}
\usage{
nams(data, A, adjusted = c("mean", "sum"), factors = c("walktrap",
  "louvain"), standardize = TRUE, method = c("TMFG", "LoGo", "PMFG",
  "threshold", "none"), normal = FALSE, na.data = c("pairwise", "listwise",
  "fiml", "none"), ...)
}
\arguments{
\item{data}{Must be a dataset}

\item{A}{Adjacency matrix that has already been filtered}

\item{adjusted}{Should adjusted values be the mean or sum score?
Defaults to "mean".
Set to "sum" for sum scores}

\item{factors}{Can be a vector of factor assignments or community detection algorithms
("walktrap" or "louvain")can be used to determine the number of factors.
Defaults to 1 factor.
Set to "walktrap" for the walktrap algortihm.
Set to "louvain" for louvain community detection}

\item{standardize}{Should mean/sum scores be standardized?
Defaults to TRUE.
Set to FALSE for unstandardized mean/sum scores}

\item{method}{A network filtering method.
Defaults to "TMFG".
The "threshold" option is set to the default arguments (thresh = "alpha", a = .05).
To use additional arguments for "threshold", apply \emph{threshold} function with
desired arguments and set to "none".
Use "none" for an adjacency matrix that has already been filtered}

\item{normal}{Should data be transform to a normal distribution?
Defaults to FALSE. Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal
(computes correlations using the \emph{cor_auto} fucntion from the \emph{qgraph} package)}

\item{na.data}{How should missing data be handled?
For "pairwise" deletion \emph{na.rm} is applied.
For "listwise" deletion the \emph{na.omit} fucntion is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\emph{psych} package).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{...}{Additional arguments for community detection algorithms}
}
\value{
Returns a list of the network adjusted score (NetAdjScore)
and the items associated with the specified or identified factors (FactorItems)
}
\description{
The hybrid centrality is used to adjust the mean or sum score of participant's factor scores based on each node's centrality.
Each participant's response values are multipled by the corresponding hybrid centrality value (uses "average" for BC argument).
In this way, more central nodes contribute a greater score and less central nodes contribute a lesser score
}
\examples{

sumadj <- nams(neoOpen, adjusted = "sum")

knownfactors <- nams(neoOpen, method = "threshold",
factors = c(rep(1,6),rep(2,6),rep(3,6),rep(4,6),rep(5,6),rep(6,6)))

walkadj <- nams(neoOpen, method="threshold", factors = "walktrap")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
