% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betweenness.R
\name{betweenness}
\alias{betweenness}
\title{Betweenness Centrality}
\usage{
betweenness(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to \code{TRUE}.
Set to \code{FALSE} for unweighted measure of betwenness centrality}
}
\value{
A vector of betweenness centrality values for each node in the network
}
\description{
Computes betweenness centrality of each node in a network
}
\examples{
A <- TMFG(neoOpen)$A

#Weighted BC
BCw <- betweenness(A)

#Unweighted BC
BC <- betweenness(A, weighted = FALSE)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
