% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.items.R
\name{core.items}
\alias{core.items}
\title{Core Items}
\usage{
core.items(A, comm, by = c("network", "communities"))
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{comm}{A vector or matrix corresponding to the community each node belongs to}

\item{by}{Should the core items be defined by network or communities?
Defaults to \code{"network"}.
Set to \code{"communities"} to define core items within communities}
}
\value{
Returns a list containing:

\item{core}{Core items for each community}

\item{inter}{Intermediate items for each community}

\item{peri}{Peripheral items for each community}
}
\description{
Automatically determines core, intermediary, and peripheral items in the network.
The entire network or within-community gradations can be determined. Based on the
\code{\link[NetworkToolbox]{hybrid}} centrality
}
\examples{
#network
A <- TMFG(neoOpen)$A

#core items by network
coreBYnetwork <- core.items(A, by = "network")

#theoretical factors
comm <- c(rep(1,8),rep(2,8),rep(3,8),rep(4,8),rep(5,8),rep(6,8))

#core items by communities
coreBYcomm <- core.items(A, comm, by = "communities")

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
