% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenvector.R
\name{eigenvector}
\alias{eigenvector}
\title{Eigenvector Centrality}
\usage{
eigenvector(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to \code{TRUE}.
Set to \code{FALSE} for unweighted measure of eigenvector centrality}
}
\value{
A vector of eigenvector centrality values for each node in the network
}
\description{
Computes eigenvector centrality of each node in a network
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

#Weighted
EC <- eigenvector(A)

#Unweighted 
EC <- eigenvector(A, weighted = FALSE)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
