% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert2igraph.R
\name{convert2igraph}
\alias{convert2igraph}
\title{Convert Network(s) to igraph's Format}
\usage{
convert2igraph(A, neural = FALSE)
}
\arguments{
\item{A}{Adjacency matrix (network matrix) or brain connectivity array
(from \code{\link[NetworkToolbox]{convertConnBrainMat}})}

\item{neural}{Is input a brain connectivity array (i.e., m x m x n)?
Defaults to \code{FALSE}.
Set to \code{TRUE} to convert each brain connectivity matrix}
}
\value{
Returns a network matrix in \code{\link{igraph}}'s format or
returns a list of brain connectivity matrices each of which have been
convert to \code{\link{igraph}}'s format
}
\description{
Converts single or multiple networks into \code{\link{igraph}}'s format for network analysis
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

igraphNetwork <- convert2igraph(A)

\dontrun{ 
neuralarray <- convertConnBrainMat()

igraphNeuralList <- convert2igraph(neuralarray, neural = TRUE)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
