% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CreatePairLinksDoubleEntered.R
\name{CreatePairLinks}
\alias{CreatePairLinks}
\alias{CreatePairLinksDoubleEntered}
\alias{CreatePairLinksDoubleEnteredWithNoOutcomes}
\alias{CreatePairLinksSingleEntered}
\title{Creates a pairs linking file.}
\usage{
CreatePairLinksDoubleEntered(outcomeDataset, linksPairDataset, outcomeNames,
   linksNames = c("ExtendedID", "R", "RelationshipPath"), validateOutcomeDataset = TRUE,
   subject1Qualifier = "_S1", subject2Qualifier = "_S2")

 CreatePairLinksSingleEntered(outcomeDataset, linksPairDataset, outcomeNames,
    linksNames = c("ExtendedID", "R", "RelationshipPath"), validateOutcomeDataset = TRUE,
    subject1Qualifier = "_S1", subject2Qualifier = "_S2")

 CreatePairLinksDoubleEnteredWithNoOutcomes(linksPairDataset,
    linksNames = c("ExtendedID", "R", "RelationshipPath"))
}
\arguments{
\item{outcomeDataset}{A data frame containing the outcome variable(s)}

\item{linksPairDataset}{A data frame containing the \code{SubjectTag}s of
each subject in the pair and their \code{R} coefficient.}

\item{outcomeNames}{The column names of the outcome variable(s)}

\item{linksNames}{The column names desired to be prseent in the newly
created data frame.  \code{SubjectTag_S1} and \code{SubjectTag_S2} are included
automatically.}

\item{validateOutcomeDataset}{Indicates if characteristics of the outcomeDataset should be validated.}

\item{subject1Qualifier}{Indicates how the outcome variable for the pair's first subject is distinguished from the other subject.  The default is \code{_S1}.}

\item{subject2Qualifier}{Indicates how the outcome variable for the pair's second subject is distinguished from the other subject.  The default is \code{_S2}.}
}
\description{
Creates a linking file for BG designs using this file structure (e.g., DF analysis, other ACE modeling).
A DF analysis requires a double-entered file that contains the \code{R}
value for the pair, and their two outcome variable values.

\code{CreatePairLinksDoubleEnteredWithNoOutcomes} is intended to be a
primarily a helper function for \code{\link{CreateSpatialNeighbours}}.
}
\examples{
dsSingleLinks <- data.frame(
  ExtendedID=c(1, 1, 1, 2),
  SubjectTag_S1=c(101, 101, 102, 201),
  SubjectTag_S2=c(102, 103, 103, 202),
  R=c(.5, .25, .25, .5),
  RelationshipPath=rep("Gen2Siblings", 4)
)
dsSingleOutcomes <- data.frame(
  SubjectTag=c(101, 102, 103, 201, 202),
  DV1=c(11, 12, 13, 41, 42),
  DV2=c(21, 22, 23, 51, 52))
dsDouble <- CreatePairLinksDoubleEntered(
  outcomeDataset=dsSingleOutcomes,
  linksPairDataset=dsSingleLinks,
  outcomeNames=c("DV1", "DV2"),
  validateOutcomeDataset=TRUE)
dsDouble #Show the 8 rows in the double-entered pair links
summary(dsDouble) #Summarize the variables

ValidatePairLinksAreSymmetric(dsDouble) #Should return TRUE.
}
\author{
Will Beasley
}
\references{
For more information about a DF analysis, see Rodgers, Joseph Lee, & Kohler, Hans-Peter (2005).
\href{http://www.springerlink.com/content/n3x1v1q282583366/}{Reformulating and simplifying the DF analysis model.}
\emph{Behavior Genetics, 35} (2), 211-217.
}

