% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nrddgp.R
\name{nrddgp}
\alias{nrddgp}
\title{Data generating process for nonlinear RDD}
\usage{
nrddgp(
  n,
  rho_R = 0.3,
  rho_U = 0.3,
  gamma_star = c(1, 1, 1),
  Nonseparable = TRUE
)
}
\arguments{
\item{n}{Sample size.}

\item{rho_R}{Correlation between R and epsilon.}

\item{rho_U}{Correlation between U and epsilon.}

\item{gamma_star}{true parameter value for the parameter in the structural function.}

\item{Nonseparable}{Whether the structural function should be estimated as a separable or nonseparable function of the treatment. The default is TRUE.}
}
\value{
Data frame whose columns are outcome Y, treatment Treat, and running variable R, respectively.
}
\description{
Generates a sample of observations based on RDD with a continuous treatment variable and a possibly nonlinear and nonseparable structural function.
}
\examples{
n <- 500
set.seed(123)
data <- nrddgp(n)
}
