% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Enders_Granger_1998.R
\name{Enders_Granger_1998}
\alias{Enders_Granger_1998}
\title{Enders and Granger_1998 nonlinear unit root test function}
\usage{
Enders_Granger_1998(x, case, max_lags, lsm)
}
\arguments{
\item{x}{series name,}

\item{case}{if raw data 1 if demeaned data 2 if detrended data 3,}

\item{max_lags}{maximum lag}

\item{lsm}{lag selection methods if 1 AIC, if 2 BIC}
}
\value{
"Model" Estimated model

"Selected lag" the lag order

"p1=p2=0 Statistic" the value of the test statistic

"p1=p2 statistic" the value of the test statistic

"prob." the probability of test statistic
}
\description{
This function allows you to make Enders and Granger(1998) nonlinear unit root test for MTAR model
}
\examples{

x <- rnorm(1000)
Enders_Granger_1998(x, case = 1, max_lags = 6, lsm = 1)

y <- cumsum(rnorm(1000))
Enders_Granger_1998(y, 2, 8, 2)

data(IBM)
Enders_Granger_1998(IBM,case = 2,max_lags = 12,lsm = 2 )


}
\references{
Enders, W., & Granger, C. W. J. (1998). Unit-root tests and asymmetric adjustment with an example using the term structure of interest rates. Journal of Business & Economic Statistics, 16(3), 304-311.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
