% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kilic_2011_unit_root.R
\name{Kilic_2011_unit_root}
\alias{Kilic_2011_unit_root}
\title{Kilic(2011) nonlinear unit root test function}
\usage{
Kilic_2011_unit_root(x, case, max_lags)
}
\arguments{
\item{x}{series name,}

\item{case}{if raw data 1 if demeaned data 2 if detrended data 3,}

\item{max_lags}{maximum lag apropriate lag length is selected by Akaike Information Criteria}
}
\value{
"Model" Estimated model

"Selected Lag" the lag order

"Test statistic" the value of the test statistic
}
\description{
This function allows you to make Kilic(2011) nonlinear unit root test
}
\examples{

\donttest{
x <- rnorm(100)
Kilic_2011_unit_root(x,1,3)

data(IBM)
Kilic_2011_unit_root(IBM, case = 3, max_lags = 12)

}

}
\references{
Kılıç, R. (2011). Testing for a unit root in a stationary ESTAR process. Econometric Reviews, 30(3), 274-302.


Burak Guris, R Uygulamalı Dogrusal Olmayan Zaman Serileri Analizi, DER Yayinevi, 2020.
}
\keyword{nonlinear}
\keyword{root}
\keyword{test}
\keyword{unit}
