% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Corr.R
\name{Corr}
\alias{Corr}
\title{Computes correlation matrix for a metabolomics dataset or 
compares the correlation between two metabolomics datasets}
\usage{
Corr(featuredata1 = NULL, featuredata2 = NULL, method = c("pearson",
  "kendall", "spearman"), padjmethod = c("BH", "holm", "hochberg", "hommel",
  "bonferroni", "BY", "fdr", "none"), saveoutput = FALSE, outputname = NULL)
}
\arguments{
\item{featuredata1}{A data frame in the featuredata format. 
 This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.}

\item{featuredata2}{A data frame in the featuredata format. 
 This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.}

\item{method}{Must be one of "pearson", "spearman" or "kendall"}

\item{padjmethod}{p-value adjustment method. Must be one of "holm", 
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr" or "none"}

\item{saveoutput}{A logical indicating whether the results
should be saved as a .csv file.}

\item{outputname}{The name of the output file if the output has to be saved.}
}
\value{
The result is an object of class `results'.
 @seealso \code{\link[DiffCorr]{comp.2.cc.fdr}}.
}
\description{
Computes correlation matrix for a metabolomics dataset or 
compares the correlation between two metabolomics datasets
}
\examples{
data("featuredata_roots")
featuredata_roots[featuredata_roots==0]<-NA
imp_data<-MissingValues(LogTransform(featuredata_roots)$featuredata)$featuredata
Corr( imp_data[c(1:17),], imp_data[c(18:37),])
Corr( imp_data[c(1:17),])

}
\references{
Fukushima, A. Gene (2013) 518, 209-214
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
