% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createEvents.R
\name{createEvents}
\alias{createEvents}
\title{Creates Events}
\usage{
createEvents(odenet)
}
\arguments{
\item{odenet}{[\code{ODEnetwork}]\cr
List of class \code{\link{ODEnetwork}}.}
}
\value{
an extended list of class [\code{\link{ODEnetwork}}].
}
\description{
Creates functions for constant and linear events of the given \code{\link{ODEnetwork}}
to know when events have to be replaced or forced.
}
\examples{
if (interactive()) {
  masses <- 1
  dampers <- as.matrix(1.5)
  springs <- as.matrix(4)
  odenet <- ODEnetwork(masses, dampers, springs)
  eventdat <- data.frame(  var = c("x.1", "x.1")
                         , time = c(1, 3)
                         , value = c(1, 3)
                         )
  odenet <- setState(odenet, 0, 0)
  odenet <- setEvents(odenet, eventdat)
  createEvents(odenet)
}
}
