% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPO.R
\name{PPO}
\alias{PPO}
\title{Projection Pursuit Optimization}
\usage{
PPO(X, y, model = "PPR", split = "gini", weights = NULL, ...)
}
\arguments{
\item{X}{An n by d numeric matrix (preferable) or data frame.}

\item{y}{A response vector of length n.}

\item{model}{Model for projection pursuit.
\itemize{
\item{"PPR"(default): projection projection regression from \code{\link{ppr}}. When y is a category label, it is
expanded to K binary features.}
\item{"Log": logistic based on \code{\link{nnet}}.}
\item{"Rand": The random projection generated from \eqn{\{-1, 1\}}.
The following models can only be used for classification, i.e. the \code{split} must be ''entropy'' or 'gini'.}
\item{"LDA", "PDA", "Lr", "GINI", and "ENTROPY" from library \code{PPtreeViz}.}
\item{The following models based on \code{\link{Pursuit}}.
\itemize{
\item{"holes": Holes index}
\item{"cm": Central Mass index}
\item{"holes": Holes index}
\item{"friedmantukey": Friedman Tukey index}
\item{"legendre": Legendre index}
\item{"laguerrefourier": Laguerre Fourier index}
\item{"hermite": Hermite index}
\item{"naturalhermite": Natural Hermite index}
\item{"kurtosismax": Maximum kurtosis index}
\item{"kurtosismin": Minimum kurtosis index}
\item{"moment": Moment index}
\item{"mf": MF index}
\item{"chi": Chi-square index}
}}
}}

\item{split}{The criterion used for splitting the variable. 'gini': gini impurity index (classification, default),
'entropy': information gain (classification) or 'mse': mean square error (regression).}

\item{weights}{Vector of non-negative observational weights; fractional weights are allowed (default NULL).}

\item{...}{optional parameters to be passed to the low level function.}
}
\value{
Optimal projection direction.
}
\description{
Find the optimal projection using various projectin pursuit models.
}
\examples{
# classification
data(seeds)
(PP <- PPO(seeds[, 1:7], seeds[, 8], model = "Log", split = "entropy"))
(PP <- PPO(seeds[, 1:7], seeds[, 8], model = "PPR", split = "entropy"))
(PP <- PPO(seeds[, 1:7], seeds[, 8], model = "LDA", split = "entropy"))

# regression
data(body_fat)
(PP <- PPO(body_fat[, 2:15], body_fat[, 1], model = "Log", split = "mse"))
(PP <- PPO(body_fat[, 2:15], body_fat[, 1], model = "Rand", split = "mse"))
(PP <- PPO(body_fat[, 2:15], body_fat[, 1], model = "PPR", split = "mse"))

}
\references{
Friedman, J. H., & Stuetzle, W. (1981). Projection pursuit regression. Journal of the American statistical Association, 76(376), 817-823.

Ripley, B. D. (1996) Pattern Recognition and Neural Networks. Cambridge.

Lee, YD, Cook, D., Park JW, and Lee, EK(2013) PPtree: Projection Pursuit Classification Tree, Electronic Journal of Statistics, 7:1369-1386.

Cook, D., Buja, A., Lee, E. K., & Wickham, H. (2008). Grand tours, projection pursuit guided tours, and manual controls. In Handbook of data visualization (pp. 295-314). Springer, Berlin, Heidelberg.
}
\seealso{
\code{\link{RotMatPPO}}
}
\keyword{rotation}
