% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{moment.determine}
\alias{moment.determine}
\title{determine the moment (largest) of the data samples}
\usage{
moment.determine(x, k.max = 8, alpha = 0.05, R = 400)
}
\arguments{
\item{x}{a numeric vector of data samples.}

\item{k.max}{a number indicating the upper bound, i.e., at most k.max-th
moment exists.}

\item{alpha}{a number in \eqn{(0,1)}, indicating the significance level of
the test.}

\item{R}{the number of standard Gaussian variables generated in the
randomized test; see also \code{\link{moment.test}}.}
}
\value{
an integer, indicating the largest moment that
exists for the data samples.
}
\description{
This function reports the largest moment that exists for a collection of
data samples.
}
\details{
The procedure will sequentially test the existence of the \eqn{4th, 6th,
8th, ... k.max-th} moment, using the function \eqn{moment.test} in the same
package. As soon as the procedure finds that the \eqn{k-th} moment does not
exist, it stops and reports at most \eqn{(k-1)-th} moment.
}
\examples{

x=rt(10000,5)
moment.determine(x,10)

x=rt(10000,4)
moment.determine(x,10)


}
\author{
Yong He, Xinbing Kong, Lorenzo Trapani, Long Yu
}
