% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{DI}
\alias{DI}
\title{A function to compute Duncan dissimilarity segregation index}
\usage{
DI(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
A matrix with Duncan dissimilarity index
}
\description{
Duncan's dissimilarity index is the most common segregation
index used to measure the segregation between different groups. For each
pair of groups, the index varies between 0 (similar distribution of groups)
to 1 (perfect spatial separation)
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
DI(x)
}
\references{
Duncan O. D. and Duncan B. (1955) \emph{A Methodological
Analysis of Segregation Indexes}. American Sociological Review 41,
pp. 210-217
}
\seealso{
Evenness intragroup  indices: \code{\link{Duncan}},
\code{\link{Wong}}, \code{\link{Morill}}, \code{\link{Gini}}, \code{\link{Gorard}}
}

