% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Duncan}
\alias{Duncan}
\title{A function to compute Duncan & Duncan segregation index}
\usage{
Duncan (x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
A vector with Duncan segregation index
}
\description{
Duncan's segregation index is one of the most used
seggregation index and varies from 0 (perfect homogenous spatial
distribution of a group) to 1 (maximum spatial segregation)
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
Duncan(x)
}
\references{
Duncan O. D. and Duncan B. (1955) \emph{A
Methodological Analysis of Segregation Indexes}.
American Sociological Review 41, pp. 210-217
}
\seealso{
Other indices based on Duncan's index:
\code{\link{Wong}}, \code{\link{Morill}}

Other evenness intragroup  indices:
\code{\link{Gini}}, \code{\link{Gorard}}

Intergroup dissimilarity index:
\code{\link{DI}}
}

