% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Gorard}
\alias{Gorard}
\title{A function to compute Gorard's segregation index}
\usage{
Gorard(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
A vector with Gorard segregation index
}
\description{
Gorard's index is an alternative to segregation indices
based on \code{\link{Duncan}}'s index. The index varies between 0
(minimum segregation) and 1 (maximum segregation).
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
Gorard(x)
}
\references{
Gorard S. (2000) \emph{Education and Social Justice}.
Cardiff, University of Wales Press
}
\seealso{
Other evenness intragroup  indices: \code{\link{Duncan}},
\code{\link{Morill}}, \code{\link{Wong}}, \code{\link{Gini}}

Intergroup dissimilarity index: \code{\link{DI}}
}

