% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{HLoc}
\alias{HLoc}
\title{A function to compute local diversity (entropy) index}
\usage{
HLoc(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
A vector with local diversity (entropy) index
}
\description{
Local adaptation of Pielou's normalised diversity
index \code{\link{JPielou}}
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
HLoc(x)
}
\references{
Theil H. (1972) \emph{Statistical Decomposition Analysis}.
North-Holland, Amsterdam
}
\seealso{
Other local indices:  location quotients \code{\link{LQ}}
}

