% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{MCTest}
\alias{MCTest}
\title{A function to test segregation indexes using Monte Carlo simulations}
\usage{
MCTest(x, fun, type = 'user', proba = NULL, c = NULL,
 b = NULL, p=NULL, a = NULL, d = NULL, dc = NULL, fdist = 'l',
 center = 1, nsim = 99, spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}

\item{fun}{- a character vector with the segregation function
to be tested (only intragroup or multigroup indexes)}

\item{type}{- a character vector with type of simulation.
If type='perm', the function will use the permutation test.
If type='rand', the population is realocated in the spatial
units randomly. If type='area', the location probabilities
are proportional to the spatial units' area. For the default
value type='user', the function expects you to introduce a
probability location vector.}

\item{proba}{- a vector with location probabilities. By
default proba = NULL being calculated depending on the
simulation type. The parameter is necessary when a user method
is specified.}

\item{c}{- a binary contiguity (adjacency) symetric matrix
where each element \emph{Cij} equals 1 if \emph{i}-th and
\emph{j}-th spatial units are adjacent, 0 otherwise. This
parameter is necessary only for some segregation functions.}

\item{b}{- a common boundaries matrix where each element
\emph{Bij} equals  the shared boundary of \emph{i}-th and
\emph{j}-th spatial units. This parameter is necessary only
for some segregation functions.}

\item{p}{- a vector with the perimeters of spatial units}

\item{a}{- a vector with areas of spatial units}

\item{d}{- a matrix with the distances between patial units
centroid}

\item{dc}{- a vector with distances from the spatial units
cetroids to the center}

\item{fdist}{- a parameter with the method used for distance
calculations: 'l' for linear (by default) and 'e' for
exponential function.}

\item{center}{- a value giving the number of the spatial unit
that represents the area's center}

\item{nsim}{- the number of simulations}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the path where the shape
file is located}

\item{shape}{- a character vector with the shape file name
#'}
}
\value{
A data frame with the simulations mean value of the index,
the rank of the index in the  simulation distribution and its pseudo
p.value
}
\description{
Monte Carlo tests for intragroup or multigroup
segregation indexes.
}
\examples{
x <- slot(AnnHAge, 'data')[ ,3:5]
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'AnnHAge'
ar <- area(AnnHAge)
distc<- distcenter(AnnHAge, center = 19)
probavector<-ar/sum(ar)

MCTest(x, fun='Duncan', type='rand', nsim=999)

MCTest(x, fun='ACE', type='perm', a = ar , dc=distc)

MCTest(x, fun='Wong', type='area', folder = foldername,
shape = shapename)

MCTest(x, fun='Morill', type='user', proba=probavector,
spatobj = AnnHAge)
}
\references{
Tivadar M., Schaeffer Y, Torre A. and Bray F. (2014)
\emph{OASIS - un Outil d'Analyse de la Segregation et des Inegalites
Spatiales}.  Cybergeo : European Journal of Geography, GeOpenMod,
document 699
}
\seealso{
\code{\link{xgeo}} function which computes all geografical
information necessary for segregation indices
}

