% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{xPy}
\alias{xPy}
\title{A function to compute interaction index (xPy)}
\usage{
xPy(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
A matrix with interaction index
}
\description{
The interaction index is an exposure index that
measures the probability that a member of a group shares the
same spatial unit with a member of another group.
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
xPy(x)
}
\references{
Bell W. (1954) \emph{A probability model for the
measurement of ecological segregation}. Social Forces 32(4),
 pp. 357-364

Massey D. S. and Denton N. A. (1988) \emph{The
dimensions of residential segregation}. Social Forces 67(2),
pp. 281-315.
}
\seealso{
Intragroup exposure indices: \code{\link{xPx}},
\code{\link{Eta2}}
}

