% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeoFunctions.R
\name{contig}
\alias{contig}
\title{A function to compute the contiguity matrix}
\usage{
contig(spatobj = NULL, folder = NULL, shape = NULL, queen = TRUE)
}
\arguments{
\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) containing 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile with the geographic information 
is located.}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension) which contains the geographic information}

\item{queen}{= TRUE (by default) for queen criteria, FALSE for rook criteria}
}
\value{
A first order contiguity (adjacency) matrix, where each 
element [\emph{i,j}] equals 1 if \emph{i}-th  and \emph{j}-th  
spatial units are adjacent, 0 otherwise (queen or rook criteria)
}
\description{
The function is based on \pkg{rgdal} and 
\pkg{spdep} packages and can be used with a shape file 
or an R spatial object (SpatialPolygonsDataFrame).
}
\examples{
 contig(segdata) 
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'
contig(folder = foldername, shape = shapename)
}
\seealso{
Other spatial functions used for segregation indices 
computation: \code{\link{area}}, \code{\link{perimeter}}, 
\code{\link{distance}}, \code{\link{distcenter}}, 
\code{\link{boundaries}}
}

