% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_Pathway_Heatmap.R
\name{olink_pathway_heatmap}
\alias{olink_pathway_heatmap}
\title{Creates a heatmap of selected pathways and proteins}
\usage{
olink_pathway_heatmap(
  enrich_results,
  test_results,
  method = "GSEA",
  keyword = NULL,
  number_of_terms = 20
)
}
\arguments{
\item{enrich_results}{data frame of enrichment results from olink_pathway_enrichment()}

\item{test_results}{filtered results from statistical test with Assay, OlinkID, and estimate columns}

\item{method}{method used in olink_pathway_enrichment ("GSEA" (default) or "ORA")}

\item{keyword}{(optional) keyword to filter enrichment results on, if not specified, displays top terms}

\item{number_of_terms}{number of terms to display, default is 20}
}
\value{
A heatmap as a ggplot object
}
\description{
Creates a heatmap of proteins related to pathways using enrichment results from olink_pathway_enrichment.
}
\examples{
\donttest{
library(dplyr)
npx_df <- npx_data1 \%>\% filter(!grepl('control',SampleID, ignore.case = TRUE))
ttest_results <- olink_ttest(df=npx_df,
                             variable = 'Treatment',
                             alternative = 'two.sided')

try({ # This expression might fail if dependencies are not installed
gsea_results <- olink_pathway_enrichment(data = npx_data1, test_results = ttest_results)
ora_results <- olink_pathway_enrichment(data = npx_data1,
                                        test_results = ttest_results, method = "ORA")
olink_pathway_heatmap(enrich_results = gsea_results, test_results = ttest_results)
olink_pathway_heatmap(enrich_results = ora_results, test_results = ttest_results,
                      method = "ORA", keyword = "cell")
})


}

}
\seealso{
\itemize{
\item{\code{\link[OlinkAnalyze:olink_pathway_enrichment]{olink_pathway_enrichment}} for generating enrichment results}
\item{\code{\link[OlinkAnalyze:olink_pathway_visualization]{olink_pathway_visualization}} for generating a bar graph of results}
}
}
