% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization.R
\name{norm_internal_adjust}
\alias{norm_internal_adjust}
\title{Combine reference and non-reference datasets}
\usage{
norm_internal_adjust(
  ref_df,
  ref_name,
  ref_cols,
  not_ref_df,
  not_ref_name,
  not_ref_cols,
  adj_fct_df
)
}
\arguments{
\item{ref_df}{The reference dataset to be used in normalization (required).}

\item{ref_name}{Project name of the reference dataset (required).}

\item{ref_cols}{Named list of column names in the reference dataset
(required).}

\item{not_ref_df}{The non-reference dataset to be used in normalization
(required).}

\item{not_ref_name}{Project name of the non-reference dataset (required).}

\item{not_ref_cols}{Named list of column names in the non-reference dataset
(required).}

\item{adj_fct_df}{Dataset containing the adjustment factors to be applied to
the non-reference dataset for (required).}
}
\value{
Tibble or ArrowObject with the normalized dataset.
}
\description{
The function is used by \code{\link{norm_internal_subset}} and
\code{\link{norm_internal_bridge}} to combine the reference dataset that has
\code{Adj_factor = 0} and the non-reference dataset that used the adjustment
factors provided in \code{adj_fct_df}.
}
\details{
The function calls \code{\link{norm_internal_adjust_ref}} and
\code{\link{norm_internal_adjust_not_ref}} and combines their outputs.
}
\author{
Klev Diamanti
}
