% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get_UMVUE_GMS}
\alias{get_UMVUE_GMS}
\title{Calculates the "uniformly minimal variance unbiased estimator".}
\usage{
get_UMVUE_GMS(k, r1, n1, n)
}
\arguments{
\item{k}{overall observed responses.}

\item{r1}{critical value for the first stage.}

\item{n1}{sample size for the first stage.}

\item{n}{overall sample size.}
}
\description{
Calculates the "uniformly minimal variance unbiased estimator" (UMVUE) for the true response rate
based on the approach of Grishick, Mosteller and Savage.
}
\examples{
#Calculate a Simon's two-stage design
design <- getSolutions()$Solutions[3,] #minimax-design for the default values.

#Assume 9 responses were observed in the whole trial.
k = 9

umvue <- get_UMVUE_GMS(k, design$r1, design$n1, design$n)
}
\references{
Girshick MA, Mosteller F, and Savage LJ (1946): Unbiased estimates for certain binomial sampling problems with applications. Annals of Mathematical Statistics, 17(1):13-23.
}

