% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VaccineSchedule.R
\name{VaccineSchedule}
\alias{VaccineSchedule}
\title{R6Class VaccineSchedule}
\description{
VaccineSchedule object has information an age-group vaccination plan.
}
\examples{
# Create a new vaccine object
model <- OpenABMCovid19::Model.new( params = list(n_total = 10000) )
Vaccine <- model$add_vaccine()

# Vaccinate 15\% of age group 70-79 and 85\% of age group 80+
vaccine.schedule <- OpenABMCovid19::VaccineSchedule$new(
  frac_70_79 = 0.15,
  frac_80    = 0.85,
  vaccine    = Vaccine
)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{fraction_to_vaccinate}}{Get the vaccination fractions per age-group.}

\item{\code{total_vaccinated}}{The total number of vaccinations per age-group.}

\item{\code{vaccine}}{The R vaccine object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{VaccineSchedule$new()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{VaccineSchedule$new(
  frac_0_9 = 0,
  frac_10_19 = 0,
  frac_20_29 = 0,
  frac_30_39 = 0,
  frac_40_49 = 0,
  frac_50_59 = 0,
  frac_60_69 = 0,
  frac_70_79 = 0,
  frac_80 = 0,
  vaccine = -1,
  fractions = NA
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{frac_0_9}}{Fraction of age group 0-9.}

\item{\code{frac_10_19}}{Fraction of age group 10-19.}

\item{\code{frac_20_29}}{Fraction of age group 20-29.}

\item{\code{frac_30_39}}{Fraction of age group 30-39.}

\item{\code{frac_40_49}}{Fraction of age group 40-49.}

\item{\code{frac_50_59}}{Fraction of age group 50-59.}

\item{\code{frac_60_69}}{Fraction of age group 60-69.}

\item{\code{frac_70_79}}{Fraction of age group 70-79.}

\item{\code{frac_80}}{Fraction of age group >80.}

\item{\code{vaccine}}{A vaccine object}

\item{\code{fractions}}{Fractions for all age groups. This is an alternative way
\code{c(frac_0_9, frac_10_19, frac_20_29, frac_30_39, frac_40_49, frac_50_59, frac_60_69, frac_70_79, frac_80)}.
If not \code{NA}, then the parameters prefixed by \code{frac_} are
ignored.}
}
\if{html}{\out{</div>}}
}
}
}
