% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxExpectationNormal.R
\name{omxManifestModelByParameterJacobian}
\alias{omxManifestModelByParameterJacobian}
\title{Estimate the Jacobian of manifest model with respect to parameters}
\usage{
omxManifestModelByParameterJacobian(model, defvar.row = 1, standardize = FALSE)
}
\arguments{
\item{model}{an mxModel}

\item{defvar.row}{which row to use for definition variables}

\item{standardize}{logical, whether or not to standardize the parameters}
}
\value{
a matrix with manifests in the rows and original parameters in the columns
}
\description{
The manifest model excludes any latent variables or processes. For
RAM and LISREL models, the manifest model contains only the
manifest variables with free means, covariance, and thresholds.
}
\details{
The Jacobian is estimated by the central finite difference.

If the \code{standardize} argument is TRUE, then the Jacobian is for the standardized model.
For Normal expectations the standardized manifest model has the covariances returned as correlations, the variances returned as ones, the means returned as zeros, and the thresholds are returned as z-scores.
For the thresholds the z-scores are computed by using the model-implied means and variances.
}
\seealso{
\link{mxGetExpected}
}
