/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

public class OsmMercator {
    private static int TILE_SIZE = 256;
    public static final double MAX_LAT = 85.05112877980659;
    public static final double MIN_LAT = -85.05112877980659;

    public static double radius(int n) {
        return (double)(TILE_SIZE * (1 << n)) / (Math.PI * 2);
    }

    public static int getMaxPixels(int n) {
        return TILE_SIZE * (1 << n);
    }

    public static int falseEasting(int n) {
        return OsmMercator.getMaxPixels(n) / 2;
    }

    public static int falseNorthing(int n) {
        return -1 * OsmMercator.getMaxPixels(n) / 2;
    }

    public static int LonToX(double d, int n) {
        int n2 = OsmMercator.getMaxPixels(n);
        int n3 = (int)((double)n2 * (d + 180.0) / 360.0);
        n3 = Math.min(n3, n2 - 1);
        return n3;
    }

    public static int LatToY(double d, int n) {
        if (d < -85.05112877980659) {
            d = -85.05112877980659;
        } else if (d > 85.05112877980659) {
            d = 85.05112877980659;
        }
        double d2 = Math.sin(Math.toRadians(d));
        double d3 = Math.log((1.0 + d2) / (1.0 - d2));
        int n2 = OsmMercator.getMaxPixels(n);
        int n3 = (int)((double)n2 * (0.5 - d3 / (Math.PI * 4)));
        n3 = Math.min(n3, n2 - 1);
        return n3;
    }

    public static double XToLon(int n, int n2) {
        return 360.0 * (double)n / (double)OsmMercator.getMaxPixels(n2) - 180.0;
    }

    public static double YToLat(int n, int n2) {
        double d = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)(n += OsmMercator.falseNorthing(n2)) / OsmMercator.radius(n2)));
        return -1.0 * Math.toDegrees(d);
    }
}

