% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvCalcBulkProfile.R
\name{cvCalcBulkProfile}
\alias{cvCalcBulkProfile}
\title{cvCalcBulkProfile Function}
\usage{
cvCalcBulkProfile(data_object, cl = 2, fileName = NULL, filePATH = NULL)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. It contains annotation
information and expression data from Bulk or single cell data.}

\item{cl}{Number of clusters. Use nCores-1 to run parallel. Default 2}

\item{fileName}{User-defined filename, Default outputFile}

\item{filePATH}{User-defined output directory \emph{PATH} Default, current directory}
}
\value{
PALMO object with CV profile cv_all
}
\description{
This function allows to calculate Intra-donor variations in bulk data over
longitudinal timepoints and visualize in a CV vs Mean plot. Plots stored in
output directory.
}
\examples{
\dontrun{
cvCalcBulkProfile(data_object=palmo_obj)
}
}
\keyword{cvCalcBulkProfile}
