% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apL1.R
\name{apL1}
\alias{apL1}
\title{Model-based Clustering with APL1}
\usage{
apL1(tuning, K = NULL, lambda = NULL, y, N = 100, kms.iter = 100, kms.nstart = 100,
      adapt.kms = FALSE, eps.diff = 1e-5, eps.em = 1e-5, model.crit = 'gic')
apL1(tuning = NULL, K, lambda, y, N = 100, kms.iter = 100, kms.nstart = 100,
      adapt.kms = FALSE, eps.diff = 1e-5, eps.em = 1e-5, model.crit = 'gic')
}
\arguments{
\item{tuning}{A 2-dimensional vector or a matrix with 2 columns, the first column is the number of clusters \eqn{K} and the second column is the tuning parameter \eqn{\lambda} in the penalty term. If this is missing, then \code{K} and \code{lambda} must be provided.}

\item{K}{The number of clusters \eqn{K}.}

\item{lambda}{The tuning parameter \eqn{\lambda} in the penalty term.}

\item{y}{A p-dimensional data matrix. Each row is an observation.}

\item{N}{The maximum number of iterations in the EM algorithm. The default value is 100.}

\item{kms.iter}{The maximum number of iterations in kmeans algorithm for generating the starting value for the EM algorithm.}

\item{kms.nstart}{The number of starting values in K-means.}

\item{adapt.kms}{A indicator of using the cluster means estimated by K-means to calculate the adaptive parameters in APFP. The default value is FALSE.}

\item{eps.diff}{The lower bound of pairwise difference of two mean values. Any value lower than it is treated as 0.}

\item{eps.em}{The lower bound for the stopping criterion.}

\item{model.crit}{The criterion used to select the number of clusters \eqn{K}. It is either `bic' for Bayesian Information Criterion or `gic' for Generalized Information Criterion.}
}
\value{
This function returns the esimated parameters and some statistics of the optimal model within the given \eqn{K} and \eqn{\lambda}, which is selected by BIC when \code{model.crit = 'bic'} or GIC when \code{model.crit = 'gic'}.
\item{mu.hat.best}{The estimated cluster means in the optimal model}
\item{sigma.hat.best}{The estimated covariance in the optimal model}
\item{p.hat.best}{The estimated cluster proportions in the optimal model}
\item{s.hat.best}{The clustering assignments using the optimal model}
\item{lambda.best}{The value of \eqn{\lambda} that provide the optimal model}
\item{K.best}{The value of \eqn{K} that provide the optimal model}
\item{llh.best}{The log-likelihood of the optimal model}
\item{gic.best}{The GIC of the optimal model}
\item{bic.best}{The BIC of the optimal model}
\item{ct.mu.best}{The degrees of freedom in the cluster means of the optimal model}
}
\description{
The adaptive \eqn{L_1} penalty was proposed by Pan and Shen (2007). Under the framework of the model-based clustering, APL1 aims to identify the globally informative variables for clustering high-dimensional data.
}
\details{
A variable is defined as globally informative if there exists at least one pair of clusters such that \eqn{\mu_{kj} \neq \mu_{k'j}}. Here we assume that each cluster has the same diagonal variance in the model-based clustering. APL1 is in the following form,
\deqn{\sum_{j=1}^d \tau_{kj}\sum_{k=1}^K |\mu_{kj}|,}
where \eqn{d} is the number of variables in the data, K is the number of clusters, \eqn{\tau_{kj} = \tilde{\mu}_{kj}} is the adaptive parameters. Here we provide two choices for \eqn{\tau_{kj}}. If \code{adapt.kms == TRUE}, \eqn{\tilde{\mu}_{kj}} is the estimates from the K-mean algorithm; otherwise, \eqn{\tilde{\mu}_{kj}} is the estimates from the model-based clustering without penalty.

The EM algorithm is used for estimating parameters. Since the EM algorithm depends on the starting values. We use the estimates from K-means with multiple starting points as the starting values.
}
\examples{
y <- rbind(matrix(rnorm(100,0,1),ncol=2), matrix(rnorm(100,4,1), ncol=2))
output <- apL1(K = c(1:2), lambda = c(0,0.1), y=y)
output$mu.hat.best

}
\references{
Pan, W. and Shen, X. (2007). Penalized model-based clustering with application to variable selection. \emph{The Journal of Machine Learning Research} \bold{8}, 1145--1164.
}
\seealso{
\code{\link{nopenalty}} \code{\link{apfp}} \code{\link{parse}}
}
\keyword{external}

