% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_preferences.R, R/summary_transition.R
\name{get_preferences}
\alias{get_preferences}
\alias{summary.transition}
\title{Obtain preference lists for predicted and actual (reference) activity
transitions}
\usage{
get_preferences(predictions, references, window_size, missing_info)

\method{summary}{transition}(object, ...)
}
\arguments{
\item{predictions}{A dummy-coded vector of predicted transitions (1)
interspersed with non-transitions (0). Logical vectors are coerced to
numeric.}

\item{references}{A dummy-coded vector of actual (i.e., reference)
transitions (1) interspersed with non-transitions (0). Logical vectors are
coerced to numeric.}

\item{window_size}{The maximum number of indices that are allowed to separate
a predicted and reference transition, before the two are considered
incompatible}

\item{object}{a \code{transition} object to analyze}

\item{...}{further arguments passed to or from methods, currently unused}
}
\value{
A list of matrices giving distance-based preferences for both the
  predicted and reference transitions, formatted to pass directly to
  \code{\link[matchingMarkets]{hri}}

a data frame containing indicators that reflect, in different ways,
  the effectiveness of predicted transitions compared to the set of actual
  (reference) transitions
}
\description{
When predicting activity transitions, the behavior of the predictor is not
known a priori. It may predict too many or too few transitions, and its
"intent" is also unknown. Therefore, some method is necessary in order to
determine which predictions (if any) should be taken to correspond to a
reference transition. There should also be a record of false positives and
false negatives. The problem is treated as an instance of the college
admissions problem, wherein both parties give their preferences for who they
would like to be matched with, and a stable arrangement is sought. This
function supports the overall goal by assigning the preferences based on the
temporal proximity of predicted and actual transitions. Preferences beyond a
specified \code{window_size} are not allowed.

Evaluate the effectiveness of predicted transitions for an object of class
\code{transition}
}
\examples{
predictions <- (sample(1:100)\%\%2)
references  <- (sample(1:100)\%\%2)
window_size <- 7
transitions <- get_transition_info(predictions, references, window_size)
summary(transitions)
}
\keyword{internal}
