% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_adjust.R
\name{residual_adjust}
\alias{residual_adjust}
\title{Perform residual adjustment on an epidemiologic variable}
\usage{
residual_adjust(d, variable, confounder, label, verbose = FALSE)
}
\arguments{
\item{d}{the input data frame on which to perform the adjustment}

\item{variable}{character. Name of variable needing adjustment}

\item{confounder}{character. Name of the confounder to adjust for}

\item{label}{character. Name to give the adjusted variable}

\item{verbose}{logical. Print updates to console?}
}
\value{
The original \code{d} object, with an extra column reflecting
  residual adjustments on the selected variable.
}
\description{
Perform residual adjustment on an epidemiologic variable
}
\examples{
d <- data.frame(
  VARIABLE = rnorm(100, 10, 2),
  CONFOUNDER = rnorm(100, 3, 7)
)
result <- residual_adjust(d, "VARIABLE", "CONFOUNDER", "ADJUSTED")

head(d)
head(result)
}
