% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeExtractClade}
\alias{PCMTreeExtractClade}
\title{Extract a clade from phylogenetic tree}
\usage{
PCMTreeExtractClade(tree, cladeRootNode, tableAncestors = NULL,
  X = NULL, returnPhylo = is.null(X))
}
\arguments{
\item{tree}{a phylo object}

\item{cladeRootNode}{a character string denoting the label or an integer denoting a node in the tree.}

\item{tableAncestors}{an integer matrix returned by a previous call to PCMTreeTableAncestors(tree) or NULL.}

\item{X}{an optional k x N matrix with trait value vectors for each tip in tree.}

\item{returnPhylo}{logical indicating if only the phylo object associated with the clade should be returned.
Defaults to \code{is.null(X)}}
}
\value{
If returnPhylo is TRUE, a phylo object associated with the clade, otherise, a list with two named members :
\itemize{
\item{tree}{the phylo object associated with the clade}
\item{X}{the submatrix of X with columns corresponding to the tips in the clade}
}
}
\description{
Extract a clade from phylogenetic tree
}
\seealso{
PCMTreeSpliAtNode PCMTreeDropClade
}
