% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeSetDefaultRegime}
\alias{PCMTreeSetDefaultRegime}
\title{Set a default edge.regime member ot the passed tree object}
\usage{
PCMTreeSetDefaultRegime(tree, regime)
}
\arguments{
\item{tree}{a phylo object}

\item{regime}{a character, an integer or PCM model object}
}
\value{
This function does not return a value but has a side effect on the passed
tree object.
}
\description{
This function sets or overwrites the current member edge.regime
in tree with one of the following:
\itemize{
\item{rep(regime[1], length(tree$edge.length))}{if regime is a character or an integer}
\item{rep(PCMRegimes(regime)[1], length(tree$edge.length))}{if regime is a PCM model}
} Note that the function modifies the passed tree object inplace.
}
