% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_BIVARIATE_ANALYSIS.R
\name{woe.tbl}
\alias{woe.tbl}
\title{Weights of evidence (WoE) table}
\usage{
woe.tbl(tbl, x, y, y.check = TRUE)
}
\arguments{
\item{tbl}{Data frame which contains target variable (\code{y}) and analyzed risk factor (\code{x}).}

\item{x}{Selected risk factor.}

\item{y}{Selected target variable.}

\item{y.check}{Logical, if target variable (\code{y}) should be checked for 0/1 values.
Default value is \code{TRUE}.
Change of this parameter to \code{FALSE} can be handy for calculation of WoE based on model
predictions. Concretely, it is used only in calculation of marginal information value (MIV) in \code{\link{stepMIV}}.}
}
\value{
The command \code{woe.tbl} returns the data frame with WoE and information value calculations along with accompanied metrics.
}
\description{
\code{woe.tbl} calculates WoE and information value for given target variable and risk factor along with
accompanied metrics needed for their calculation.
WoE table reports:
\itemize{
\item bin: Risk factor group (bin).
\item no: Number of observations per bin.
\item ng: Number of good cases (where target is equal to 0) per bin.
\item nb: Number of bad cases (where target is equal to 1) per bin.
\item pct.o: Percentage of observations per bin.
\item pct.g: Percentage of good cases (where target is equal to 0) per bin.
\item pct.b: Percentage of bad cases (where target is equal to 1) per bin.
\item dr: Default rate per bin.
\item so: Number of all observations.
\item sg: Number of all good cases.
\item sb: Number of all bad cases.
\item dist.g: Distribution of good cases per bin.
\item dist.b: Distribution of bad cases per bin.
\item woe: WoE value.
\item iv.b: Information value per bin.
\item iv.s: Information value of risk factor (sum of individual bins' information values).
}
}
\examples{
suppressMessages(library(PDtoolkit))
data(gcd)
#categorize numeric risk factors
gcd$age.bin <- woe.bin(x = gcd$age, y = gcd$qual, y.type = "bina")[[2]]
#generate woe table
woe.tbl(tbl = gcd, x = "age.bin", y = "qual")
}
\seealso{
\code{\link{bivariate}} for automatic bivariate analysis.
}
