% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose.intervals.R
\name{choose.auc.intervals}
\alias{choose.auc.intervals}
\title{Choose intervals to compute AUCs from time and dosing information}
\usage{
choose.auc.intervals(
  time.conc,
  time.dosing,
  options = list(),
  single.dose.aucs = NULL
)
}
\arguments{
\item{time.conc}{Time of concentration measurement}

\item{time.dosing}{Time of dosing}

\item{options}{List of changes to the default
\code{\link{PKNCA.options}} for calculations.}

\item{single.dose.aucs}{The AUC specification for single dosing.}
}
\value{
A data frame with columns for \code{start}, \code{end},
\code{auc.type}, and \code{half.life}.  See
\code{\link{check.interval.specification}} for column definitions.
The data frame may have zero rows if no intervals could be found.
}
\description{
Intervals for AUC are selected by the following metrics:
\enumerate{
  \item If only one dose is administered, use the
        \code{PKNCA.options("single.dose.aucs")}
  \item If more than one dose is administered, estimate the AUC
        between any two doses that have PK taken at both of the
        dosing times and at least one time  between the doses.
  \item For the final dose of multiple doses, try to determine the
        dosing interval (\eqn{\tau}) and estimate the AUC in that
        interval if multiple samples are taken in the interval.
  \item If there are samples \eqn{> \tau} after the last dose,
        calculate the half life after the last dose.
 }
}
\seealso{
\code{\link{pk.calc.auc}}, \code{\link{pk.calc.aumc}},
\code{\link{pk.calc.half.life}}, \code{\link{PKNCA.options}}

Other Interval specifications: 
\code{\link{add.interval.col}()},
\code{\link{check.interval.deps}()},
\code{\link{check.interval.specification}()},
\code{\link{get.interval.cols}()},
\code{\link{get.parameter.deps}()}

Other Interval determination: 
\code{\link{find.tau}()}
}
\concept{Interval determination}
\concept{Interval specifications}
