% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_bins_df.R
\name{set_bins_df}
\alias{set_bins_df}
\title{given a set of bin ranges, assign each value to a bin and provide the label}
\usage{
set_bins_df(
  .df,
  .x,
  breaks = stats::quantile(.df[[.x]], na.rm = T),
  .name = NULL,
  .label = NULL,
  lower_bound = -Inf,
  upper_bound = Inf,
  quiet = TRUE,
  between = NULL,
  inclusive = TRUE
)
}
\arguments{
\item{.df}{data frame}

\item{.x}{name of column}

\item{breaks}{breaks for each bin, defaults to quantiles}

\item{.name}{name of new binned column, defaults to appending _bin to column name}

\item{.label}{name of the new label column, defaults to appending _label to bin column name}

\item{lower_bound}{set a lower bound for the first bin, defaults to -Inf}

\item{upper_bound}{set an upper bound for the last bind, defaults to Inf}

\item{quiet}{whether to give additonal information regarding bins and assigned range for each}

\item{between}{defaults to NULL, a special case of setting all inside the specified range}

\item{inclusive}{include max value of largest user defined bin even though lower bins are non-inclusive}
}
\description{
given a set of bin ranges, assign each value to a bin and provide the label
}
\details{
set_bins_df offers the ability to create bins from a dataframe and get both the binning column
as well as a label column with the range of values associated with a given bin
}
\seealso{
\code{\link{set_bins}}
}
