% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLindleyROC.R
\name{PLindleyROC}
\alias{PLindleyROC}
\alias{dPLD}
\alias{pPLD}
\alias{qPLD}
\alias{rPLD}
\alias{plAUC}
\alias{plJ}
\alias{plER}
\alias{plCZ}
\alias{plIU}
\alias{plNI}
\alias{plROC}
\alias{prfROC}
\title{Receiver Operating Characteristic for Power Lindley Distribution}
\usage{
dPLD(x, alpha, beta)

pPLD(x, alpha, beta)

qPLD(p, alpha, beta)

rPLD(n, alpha, beta)

plAUC(alpha1, beta1, alpha2, beta2)

plJ(alpha1, beta1, alpha2, beta2, init = 0)

plER(alpha1, beta1, alpha2, beta2, init = 0)

plCZ(alpha1, beta1, alpha2, beta2, init = 0)

plIU(alpha1, beta1, alpha2, beta2, init = 0)

plNI(alpha1, beta1, alpha2, beta2, init = 0)

plROC(x, y, alpha1, beta1, alpha2, beta2, empirical = TRUE)

prfROC(ctp = 0, alpha1, beta1, alpha2, beta2)
}
\arguments{
\item{x, y}{vector of quantiles.}

\item{alpha}{shape parameter.}

\item{beta}{scale parameter.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}

\item{alpha1}{shape parameter of first sample.}

\item{beta1}{scale parameter of first sample.}

\item{alpha2}{shape parameter of second sample.}

\item{beta2}{scale parameter of second sample.}

\item{init}{initial value for the optimization calculation.}

\item{empirical}{empirical must be TRUE or FALSE.}

\item{ctp}{cut-off point value.}
}
\value{
\code{dPLD} gives the probability density function of Power
Lindley Distribution.

\code{pPLD} gives the cumulative density function of
Power Lindley Distribution.

\code{qPLD} gives the quantile function of
Power Lindley Distribution.

\code{rPLD} gives random numbers from Power Lindley Distribution.

\code{plAUC} gives area under curve of Power
Lindley Distribution. Area under the ROC curve is obtained.

\code{plJ} gives Youden's index for Power Lindley Distribution.
Youden's J statistics is a way of summarising the performance of a
diagnostic test.

\code{plER} gives the Closest to (0,1) Criteria (ER)
for Power Lindley Distribution. The Closest to (0,1) Criteria (ER)
is a way of summarising the performance of a diagnostic test.

\code{plCZ} gives the Concordance Probability Method
for Power Lindley Distribution. The Concordance Probability Method
is a way of summarising the performance of a diagnostic test.

\code{plIU} gives the Index of Union  for Power
Lindley Distribution. The Index of Union is a way of summarising
the performance of a diagnostic test.

\code{plNI} gives the New Index for Power Lindley Distribution.

\code{plROC} gives the ROC graph for Power Lindley Distribution.
The ROC graph is given by 1-specificity versus sensitivity.

\code{prfROC} gives sensitivity,specificity and 1-specificity
for Power Lindley Distribution.
}
\description{
Receiver operating characteristic (ROC) analysis is carried out
from the Power Lindley distribution. Specificity, sensitivity, area under the
curve, and ROC curve are evaluated.
}
\details{
The probability density function (PDF) and cumulative distribution function
(CDF) are as follows:
\deqn{f\left( x\right) =\frac{\alpha \beta ^{2}}{\beta +1}\left( 1+x^{\alpha}
\right) x^{\alpha -1}\exp \left( -\beta x^{\alpha }\right)}
\deqn{=zg_{1}\left( t\right) +\left( 1-z\right) g_{2}\left( t\right)}

\deqn{F\left( x\right) =P\left( X\leq x\right) =1-\left( 1+zx^{\alpha }
\right)
\exp \left( -\beta x^{\alpha }\right)}
and quantile function is given by,
\deqn{Q\left( u\right) =F^{-1}\left( u\right) =\left\{ -\frac{W\left( \left(
1+\beta \right) \left( -1+u\right) \exp \left( -\left( 1+\beta \right)
                                              \right) \right) +1+\beta }
                                       {\beta }\right\} ^{\frac{1}{\alpha }}}
,where
\deqn{z =\frac{\beta }{\beta +1}}
\deqn{g_{1}\left( x\right)  =\alpha \beta x^{\alpha -1}\exp \left( -\beta
x^{\alpha }\right)}
\deqn{g_{2}\left( x\right)  =\alpha \beta ^{2}x^{2\alpha -1}\exp \left(-\beta
x^{\alpha }\right)}
\eqn{\alpha>0} is a shape parameter, \eqn{\beta>0} is a scale parameter,
\eqn{0<u<1} and \eqn{W} is Lambert W function.

Let \eqn{c} be the cut-off point, \eqn{X_{1}\sim PL\left( \alpha_{1},
\beta_{1}\right) }
and \eqn{X_{2}\sim PL\left( \alpha_{2},\beta_{2}\right) } with
\eqn{\alpha_{2}>\alpha_{1}}.
\eqn{F_{1}} and \eqn{F_{2}} are the cumulative distribution functions related
to \eqn{X_{1}} and \eqn{X_{2}}, respectively.
In that case, the 1-specificity (False Positive Rate,FPR) and sensitivity
(True Positive Rate,TPR) are given by,
\deqn{FPR =P\left( X_{1}>c\right) =1-P\left( X_{1}\leq c\right) =1-F_{1}
\left(c\right)}
\deqn{TPR =1-F_{2}\left( Q_{1}\left( 1-FPR\right) \right)}
and Receiver Operating Characteristic (ROC) curve can be expressed
as follows:
\deqn{ROC =\left\{\left(r,( 1-F_{2}\left( Q_{1}\left(
1-r; \boldsymbol{\theta }\right) \right),
r\in \left( 0,1\right) \right)\right\}},
where \eqn{\boldsymbol{\theta }=\left( \alpha _{1},\alpha _{2},
\beta _{1},\beta_{2}\right)}.

Performance assesments for the ROC analysis are as follows:
\deqn{AUC =\int\limits_{0}^{1}ROCdr}
\deqn{J\left( c\right)  =\underset{c}{\arg \max }
\left\{ \left( 1-F_{2}\left( c\right)
\right) +F_{1}\left( c\right) -1\right\}}
\deqn{ER\left( c\right)  = \underset{c}{\arg \min }
 \left\{ \sqrt{\left( 1-F_{1}\left( c\right) \right)
^{2}+\left( F_{2}\left( c\right) \right) ^{2}} \right\}}
\deqn{CZ\left( c\right)  = \underset{c}{\arg \max }
\left\{ \left( 1-F_{2}\left( c\right) \right) \times F_{1}\left(
c\right)  \right\}}
\deqn{IU\left( c\right)  =\left\{ \left\vert \left( 1-F_{2}\left( c\right)
-AUC\right) \right\vert +\left\vert F_{1}\left( c\right) -AUC\right\vert
\right\}}
\deqn{NI\left( c\right)  =\underset{c}{\arg \max }\left\{ \left( \left(
1-F_{1}\left( c\right) \right) \times F_{2}\left( c\right) \times
F_{1}\left( c\right) \times \left( 1-F_{2}\left( c\right) \right) \right)
\right.   \nonumber \\
\left. +\left( F_{1}\left( c\right) \times F_{2}\left( c\right) \times
                \left( 1-F_{1}\left( c\right) \right) \times
                \left( 1-F_{2}\left( c\right)
                                                   \right) \right) \right\}}
,where AUC is area under the ROC curve, J is Youden's J index, ER is the
closest to
\eqn{\left( 0,1\right)} criteria, CZ is the concordance probability method,
IU is index of Union and NI is new index.
}
\examples{
dPLD(c(1,2,3,4,5,200),alpha=3,beta=2)
pPLD(c(.5,1,2,3,4),alpha=3,beta=2)
qPLD(c(.9971,0.5,0.3),alpha=3,beta=2)
rPLD(10,alpha=3,beta=2)
\donttest{plAUC(alpha1=2,beta1=5,alpha2=6,beta2=1)}
plJ(alpha1=2,beta1=5,alpha2=6,beta2=1,init=0)
plER(alpha1=2,beta1=5,alpha2=6,beta2=1,init=0)
plCZ(alpha1=2,beta1=5,alpha2=6,beta2=1,init=0)
\donttest{plIU(alpha1=2,beta1=5,alpha2=6,beta2=1,init=0)}
\donttest{plNI(alpha1=2,beta1=5,alpha2=6,beta2=1,init=0.5)}
\donttest{x=c(1,2,3,4)}
\donttest{y=c(2,3,4)}
\donttest{plROC(x,y,alpha1=2,beta1=5,alpha2=6,beta2=1,empirical=FALSE)}
prfROC(ctp=0.5,alpha1=2,beta1=5,alpha2=6,beta2=1)
}
\references{
Akgenç, E., and Kuş, C., 2023,
\emph{ROC Curve Analysis for the Measurements Distributed Power-Lindley}
\emph{Distribution},
2nd International E-Conference On Mathematical And Statistical Sciences:
A Selçuk Meeting (ICOMSS-2023), Konya, 25.

Attwood, K., Hou, S., and Hutson, A., 2022,
\emph{Application of the skew exponential power distribution to ROC curves},
Journal of Applied Statistics, 1-16.

Ghitany M., Al-Mutairi D. K., Balakrishnan N., and Al-Enezi L., 2013,
\emph{Power lindley distribution and associated inference},
Computational Statistics & Data Analysis, 64,20–33.

Liu, X., 2012,
\emph{Classification accuracy and cut point selection},
Statistics in medicine, 31(23), 2676-2686.

Nahm, F. S., 2022,
\emph{Receiver operating characteristic curve: overview and practical use for}
\emph{clinicians},
Korean journal of anesthesiology, 75(1), 25-36.

Perkins, N. J., and Schisterman, E. F., 2006,
\emph{The inconsistency of “optimal” cutpoints obtained using two}
\emph{criteria based on the receiver operating characteristic curve},
American journal of epidemiology, 163(7), 670-675.

Pundir, S. and Amala, R., 2014,
\emph{Evaluation of area under the constant shape bi-weibull roc curve},
Journal of Modern Applied Statistical Methods, 13(1),1-20.

Youden, W. J., 1950,
\emph{Index for rating diagnostic tests}, Cancer, 3(1), 32-35.
}
