% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/johnsonTest.R
\name{johnsonTest}
\alias{johnsonTest}
\alias{johnsonTest.default}
\alias{johnsonTest.formula}
\title{Testing against Ordered Alternatives (Johnson-Mehrotra Test)}
\usage{
johnsonTest(x, ...)

\method{johnsonTest}{default}(x, g, alternative = c("two.sided", "greater", "less"), ...)

\method{johnsonTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("two.sided", "greater", "less"),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{"two.sided"}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated quantile of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{parameter}{the parameters of the test statistic, if any.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs the Johnson-Mehrotra test for testing against ordered alternatives
in a balanced one-factorial sampling design.
}
\details{
The null hypothesis, H\eqn{_0: \theta_1 = \theta_2 = \ldots = \theta_k}
is tested against a simple order hypothesis,
H\eqn{_\mathrm{A}: \theta_1 \le \theta_2 \le \ldots \le
\theta_k,~\theta_1 < \theta_k}.

The p-values are estimated from the standard normal distribution.
}
\note{
Factor labels for \code{g} must be assigned in such a way,
that they can be increasingly ordered from zero-dose
control to the highest dose level, e.g. integers {0, 1, 2, ..., k} or
letters {a, b, c, ...}. Otherwise the function may not
select the correct values for intended zero-dose control.

It is safer, to i) label the factor levels as given above,
and to ii) sort the data according to increasing dose-levels
prior to call the function (see \code{\link{order}}, \code{\link{factor}}).
}
\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
       110, 125, 143, 148, 151,
       136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("A", "B", "C")

## Chacko's test
chackoTest(x, g)

## Cuzick's test
cuzickTest(x, g)

## Johnson-Mehrotra test
johnsonTest(x, g)

## Jonckheere-Terpstra test
jonckheereTest(x, g)

## Le's test
leTest(x, g)

## Spearman type test
spearmanTest(x, g)

## Murakami's BWS trend test
bwsTrendTest(x, g)

## Fligner-Wolfe test
flignerWolfeTest(x, g)

## Shan-Young-Kang test
shanTest(x, g)

}
\references{
Bortz, J. (1993). \emph{Statistik für Sozialwissenschaftler} (4th ed.).
Berlin: Springer.

Johnson, R. A., Mehrotra, K. G. (1972) Some c-sample
nonparametric tests for ordered alternatives.
\emph{Journal of the Indian Statistical Association} \bold{9}, 8--23.
}
\seealso{
\code{\link{kruskalTest}} and \code{\link{shirleyWilliamsTest}}
of the package \pkg{PMCMRplus},
\code{\link[stats]{kruskal.test}} of the library \pkg{stats}.
}
\concept{trendtest}
\keyword{htest}
\keyword{nonparametric}
