% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{sensitivity}
\alias{sensitivity}
\title{Sensitivity Analysis.}
\usage{
sensitivity(task_dists, cor_mat = NULL)
}
\arguments{
\item{task_dists}{A list of lists describing each task distribution.}

\item{cor_mat}{The correlation matrix for the tasks.}
}
\value{
The function returns a vector of sensitivity results with respect to
each task.
}
\description{
Sensitivity Analysis.
}
\examples{
task_dists <- list(
  list(type = "normal", mean = 10, sd = 2),  # Task A: Normal distribution
  list(type = "triangular", a = 5, b = 15, c = 10),  # Task B: Triangular distribution
  list(type = "uniform", min = 8, max = 12)  # Task C: Uniform distribution
)
cor_mat <- matrix(c(
  1, 0.5, 0.3,
 0.5, 1, 0.4,
  0.3, 0.4, 1
), nrow = 3, byrow = TRUE)
sensitivity_results <- sensitivity(task_dists, cor_mat)
cat("Sensitivity of the variance in total cost with respect to the variance in each task cost:\n")
print(sensitivity_results)
}
