% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_crs_text.R
\name{proj_crs_text}
\alias{proj_crs_text}
\title{Generate a projection string.}
\usage{
proj_crs_text(source, format = 0L)
}
\arguments{
\item{source}{input projection specification one of ('PROJ4', 'WKT2',
'EPSG', 'PROJJSON', ... see the library documentation link in Details)}

\item{format}{integer, 0 for 'WKT', 1 for 'PROJ'}
}
\value{
character string in requested format
}
\description{
Input any accepted format of 'PROJ' coordinate reference system specification.
Return value is a string in the requested format.
}
\details{
This function requires PROJ version 6.0 or higher to be useful. If not, this
function simply returns 'NA'.

See the \href{https://proj.org/development/reference/functions.html#transformation-setup}{library documentation}
for details on input and output formats.

Some nuances of the format are not available, currently we use formats
'0: PJ_WKT2_2018' '1: PJ_PROJ_5', '2: PROJJSON'.

Some formats are hard to read, such as WKT so for easy reading
use \code{cat()}.
}
\examples{
# all examples are disabled
#cat(proj_crs_text("EPSG:4326", format = 0L))
#proj_crs_text("EPSG:4326", format = 1L)
#south55 <- "+proj=utm +zone=55 +south +ellps=GRS80 +units=m +no_defs +type=crs"
#proj_crs_text(proj_crs_text(south55), 1L)
}
